<?php
/**
 * Config related constants.
 *
 * @package Neve\Core\Settings
 */

namespace Neve\Core\Settings;

/**
 * Class Admin
 *
 * @package Neve\Core\Settings
 */
class Config {

	const MODS_LINK_COLOR                  = 'neve_link_color';
	const MODS_LINK_HOVER_COLOR            = 'neve_link_hover_color';
	const MODS_TEXT_COLOR                  = 'neve_text_color';
	const MODS_CONTAINER_WIDTH             = 'neve_container_width';
	const MODS_SITEWIDE_CONTENT_WIDTH      = 'neve_sitewide_content_width';
	const MODS_OTHERS_CONTENT_WIDTH        = 'neve_other_pages_content_width';
	const MODS_ARCHIVE_CONTENT_WIDTH       = 'neve_blog_archive_content_width';
	const MODS_SINGLE_CONTENT_WIDTH        = 'neve_single_post_content_width';
	const MODS_SHOP_ARCHIVE_CONTENT_WIDTH  = 'neve_shop_archive_content_width';
	const MODS_SHOP_SINGLE_CONTENT_WIDTH   = 'neve_single_product_content_width';
	const MODS_ADVANCED_LAYOUT_OPTIONS     = 'neve_advanced_layout_options';
	const MODS_BUTTON_PRIMARY_STYLE        = 'neve_button_appearance';
	const MODS_BUTTON_SECONDARY_STYLE      = 'neve_secondary_button_appearance';
	const MODS_BUTTON_PRIMARY_PADDING      = 'neve_button_padding';
	const MODS_BACKGROUND_COLOR            = 'background_color';
	const MODS_BUTTON_SECONDARY_PADDING    = 'neve_secondary_button_padding';
	const MODS_TYPEFACE_GENERAL            = 'neve_typeface_general';
	const MODS_TYPEFACE_H1                 = 'neve_h1_typeface_general';
	const MODS_TYPEFACE_H2                 = 'neve_h2_typeface_general';
	const MODS_TYPEFACE_H3                 = 'neve_h3_typeface_general';
	const MODS_TYPEFACE_H4                 = 'neve_h4_typeface_general';
	const MODS_TYPEFACE_H5                 = 'neve_h5_typeface_general';
	const MODS_TYPEFACE_H6                 = 'neve_h6_typeface_general';
	const MODS_FONT_GENERAL                = 'neve_body_font_family';
	const MODS_FONT_HEADINGS               = 'neve_headings_font_family';
	const MODS_DEFAULT_CONTAINER_STYLE     = 'neve_default_container_style';
	const MODS_SINGLE_POST_CONTAINER_STYLE = 'neve_single_post_container_style';

	const MODS_TYPEFACE_ARCHIVE_POST_TITLE   = 'neve_archive_typography_post_title';
	const MODS_TYPEFACE_ARCHIVE_POST_EXCERPT = 'neve_archive_typography_post_excerpt';
	const MODS_TYPEFACE_ARCHIVE_POST_META    = 'neve_archive_typography_post_meta';

	const MODS_TYPEFACE_SINGLE_POST_TITLE         = 'neve_single_post_typography_post_title';
	const MODS_TYPEFACE_SINGLE_POST_META          = 'neve_single_post_typography_post_meta';
	const MODS_TYPEFACE_SINGLE_POST_COMMENT_TITLE = 'neve_single_post_typography_comments_title';

	const CSS_PROP_BORDER_COLOR               = 'border-color';
	const CSS_PROP_BACKGROUND_COLOR           = 'background-color';
	const CSS_PROP_COLOR                      = 'color';
	const CSS_PROP_MAX_WIDTH                  = 'max-width';
	const CSS_PROP_BORDER_RADIUS_TOP_LEFT     = 'border-top-left-radius';
	const CSS_PROP_BORDER_RADIUS_TOP_RIGHT    = 'border-top-right-radius';
	const CSS_PROP_BORDER_RADIUS_BOTTOM_RIGHT = 'border-bottom-right-radius';
	const CSS_PROP_BORDER_RADIUS_BOTTOM_LEFT  = 'border-bottom-left-radius';
	const CSS_PROP_BORDER_RADIUS              = 'border-radius';
	const CSS_PROP_BORDER_WIDTH               = 'border-width';
	const CSS_PROP_BORDER                     = 'border';
	const CSS_PROP_FLEX_BASIS                 = 'flex-basis';
	const CSS_PROP_PADDING                    = 'padding';
	const CSS_PROP_PADDING_RIGHT              = 'padding-right';
	const CSS_PROP_PADDING_LEFT               = 'padding-left';
	const CSS_PROP_MARGIN                     = 'margin';
	const CSS_PROP_MARGIN_LEFT                = 'margin-left';
	const CSS_PROP_MARGIN_RIGHT               = 'margin-right';
	const CSS_PROP_WIDTH                      = 'width';
	const CSS_PROP_HEIGHT                     = 'height';
	const CSS_PROP_FONT_SIZE                  = 'font-size';
	const CSS_PROP_FILL_COLOR                 = 'fill';
	const CSS_PROP_LETTER_SPACING             = 'letter-spacing';
	const CSS_PROP_LINE_HEIGHT                = 'line-height';
	const CSS_PROP_FONT_WEIGHT                = 'font-weight';
	const CSS_PROP_TEXT_TRANSFORM             = 'text-transform';
	const CSS_PROP_FONT_FAMILY                = 'font-family';
	const CSS_PROP_BOX_SHADOW                 = 'box-shadow';

	const CSS_PROP_CUSTOM_BTN_TYPE           = 'btn-type';
	const CSS_PROP_CUSTOM_FONT_WEIGHT_FAMILY = 'btn-type';

	const CSS_SELECTOR_BTN_PRIMARY_NORMAL    = 'buttons_primary_normal';
	const CSS_SELECTOR_BTN_PRIMARY_HOVER     = 'buttons_primary_hover';
	const CSS_SELECTOR_BTN_SECONDARY_NORMAL  = 'buttons_secondary_normal';
	const CSS_SELECTOR_BTN_SECONDARY_HOVER   = 'buttons_secondary_hover';
	const CSS_SELECTOR_BTN_PRIMARY_PADDING   = 'buttons_primary_padding';
	const CSS_SELECTOR_BTN_SECONDARY_PADDING = 'buttons_secondary_padding';
	const CSS_SELECTOR_TYPEFACE_GENERAL      = 'typeface_general';
	const CSS_SELECTOR_TYPEFACE_H1           = 'typeface_h1';
	const CSS_SELECTOR_TYPEFACE_H2           = 'typeface_h2';
	const CSS_SELECTOR_TYPEFACE_H3           = 'typeface_h3';
	const CSS_SELECTOR_TYPEFACE_H4           = 'typeface_h4';
	const CSS_SELECTOR_TYPEFACE_H5           = 'typeface_h5';
	const CSS_SELECTOR_TYPEFACE_H6           = 'typeface_h6';

	const CSS_SELECTOR_ARCHIVE_POST_TITLE   = 'archive_entry_title';
	const CSS_SELECTOR_ARCHIVE_POST_EXCERPT = 'archive_entry_summary';
	const CSS_SELECTOR_ARCHIVE_POST_META    = 'archive_entry_meta_list';

	const CSS_SELECTOR_SINGLE_POST_TITLE         = 'single_post_entry_title';
	const CSS_SELECTOR_SINGLE_POST_META          = 'single_post_entry_meta_list';
	const CSS_SELECTOR_SINGLE_POST_COMMENT_TITLE = 'single_post_comment_title';

	const CONTENT_DEFAULT_PADDING = 30;
	/**
	 * Holds tag->css selector mapper.
	 *
	 * @var array Mapper.
	 */
	public static $css_selectors_map = [
		self::CSS_SELECTOR_TYPEFACE_H1               => 'h1, .single h1.entry-title',
		self::CSS_SELECTOR_TYPEFACE_H2               => 'h2',
		self::CSS_SELECTOR_TYPEFACE_H3               => 'h3',
		self::CSS_SELECTOR_TYPEFACE_H4               => 'h4',
		self::CSS_SELECTOR_TYPEFACE_H5               => 'h5',
		self::CSS_SELECTOR_TYPEFACE_H6               => 'h6',
		self::CSS_SELECTOR_TYPEFACE_GENERAL          => 'body, .site-title',
		self::CSS_SELECTOR_BTN_PRIMARY_PADDING       => '.button.button-primary,  .wp-block-button.is-style-primary .wp-block-button__link',
		self::CSS_SELECTOR_BTN_SECONDARY_PADDING     => '.button.button-secondary, #comments input[type="submit"],   .wp-block-button.is-style-secondary .wp-block-button__link',
		self::CSS_SELECTOR_BTN_PRIMARY_NORMAL        => '.button.button-primary,
				button, input[type=button],
				.btn, input[type="submit"],
				/* Buttons in navigation */
				ul[id^="nv-primary-navigation"] li.button.button-primary > a,
				.menu li.button.button-primary > a,  .wp-block-button.is-style-primary .wp-block-button__link',
		self::CSS_SELECTOR_BTN_PRIMARY_HOVER         => '.button.button-primary:hover,
				.nv-tags-list a:hover,
				ul[id^="nv-primary-navigation"] li.button.button-primary > a:hover,
				.menu li.button.button-primary > a:hover, .wp-block-button.is-style-primary .wp-block-button__link:hover ',
		self::CSS_SELECTOR_BTN_SECONDARY_NORMAL      => '.button.button-secondary, #comments input[type="submit"], .cart-off-canvas .button.nv-close-cart-sidebar,  .wp-block-button.is-style-secondary .wp-block-button__link',
		self::CSS_SELECTOR_BTN_SECONDARY_HOVER       => '.button.button-secondary:hover, #comments input[type="submit"]:hover, .cart-off-canvas .button.nv-close-cart-sidebar:hover,  .wp-block-button.is-style-secondary .wp-block-button__link:hover',
		self::CSS_SELECTOR_ARCHIVE_POST_TITLE        => '.blog .blog-entry-title, .archive .blog-entry-title',
		self::CSS_SELECTOR_ARCHIVE_POST_EXCERPT      => '.blog .entry-summary, .archive .entry-summary, .blog .post-pages-links',
		self::CSS_SELECTOR_ARCHIVE_POST_META         => '.blog .nv-meta-list li, .archive .nv-meta-list li',
		self::CSS_SELECTOR_SINGLE_POST_TITLE         => '.single h1.entry-title',
		self::CSS_SELECTOR_SINGLE_POST_META          => '.single .nv-meta-list li',
		self::CSS_SELECTOR_SINGLE_POST_COMMENT_TITLE => '.single .comment-reply-title',
	];
}
