<?php
/**
 * The template for displaying all single posts.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Construction_Landing_Page
 */

get_header(); ?>

	<div id="primary" class="content-area">
		<main id="main" class="site-main" role="main">

		<?php
		while ( have_posts() ) : the_post();

			get_template_part( 'template-parts/content', 'single' );

			$exclude_categories = !empty( get_theme_mod( 'construction_landing_page_exclude_cat' ) ) ? get_theme_mod( 'construction_landing_page_exclude_cat' ) : '';

			the_post_navigation( array( 'excluded_terms'=> $exclude_categories ) );
            
            construction_landing_page_post_author(); //Author Bio

			// If comments are open or we have at least one comment, load up the comment template.
			if ( comments_open() || get_comments_number() ) :
				comments_template();
			endif;

		endwhile; // End of the loop.
		?>

		</main><!-- #main -->
	</div><!-- #primary -->

<?php
get_sidebar();
get_footer();
