# Orbit Fox by ThemeIsle #
**Contributors:** [themeisle](https://profiles.wordpress.org/themeisle), [codeinwp](https://profiles.wordpress.org/codeinwp), [rodicaelena](https://profiles.wordpress.org/rodicaelena), [baicusandrei](https://profiles.wordpress.org/baicusandrei), [hardeepasrani](https://profiles.wordpress.org/hardeepasrani)  
**Tags:** widget, admin, widgets, sharing, sections, themes, stock photos, custom icons, icons, menu icons, stock, templates, header, footer, scripts, custom fonts   
**Requires at least:** 4.7  
**Tested up to:** 5.8  
**Requires PHP:** 5.6  
**Stable tag:** trunk  
**License:** GPLv2 or later  
**License URI:** http://www.gnu.org/licenses/gpl-2.0.html  

This swiss-knife plugin comes with a quality template library, menu/sharing icons, Elementor/BeaverBuilder page builder widgets and many more.

## Description ##

Extend your theme functionality with <a href="https://orbitfox.com/" rel="nofollow">Orbit Fox</a> with various modules like Social Media Share Buttons & Icons, Custom Menu Icons, Header and Footer Scripts, one click import page templates, page builder addons and free stock featured images.

https://www.youtube.com/watch?v=YHhK_twfYB8

**Features:**
- Privacy policy notice ( GDPR friendly )
- Template Directory
- Elementor Addons and Widgets
- Beaver Builder Widgets
- Sharing module
- Menu icons module
- Free stock photos module
- Custom fonts module
- Header and footer scripts module
- More widgets and sections for Hestia Theme
- More widgets and sections for Zerif Theme

You can check out the demo <a href="https://orbitfox.com/#blog" rel="nofollow" target="_blank">here</a> for a more detailed overview of the features.

OrbitFox is a user-centred plugin with an easy-to-use admin panel. One of the most important features is that modules will only be loaded if they meet two conditions. If they are needed and if they are compatible with your existing themes and plugins. This will cut down on the unnecessary bloating of your website.

We've also built some fantastic <a href="http://themeisle.com/wordpress-themes/free/" rel="nofollow" target="_blank">free themes</a> that work well with Orbit Fox, check them out.

## Frequently Asked Questions ##

### How I can get support for this plugin ? ###

You can learn more about Orbit Fox and ask for help by <a href="https://themeisle.com/contact/"  >visiting ThemeIsle website</a>.

### What can I do with this plugin ###
This plugin extends the features of your sites by adding numerous features.

**Why use our custom icons module:**
- Choose from a large variety of custom icons.
- No coding needed, you can leverage the power of our dropdown icons selector and choose the right icon for your menu.

**Why use our sharing module:**
- It's easy to use
- Enable sharing networks right from your admin dashboard and choose on what kind of devices you would like to show them.
- It’s fully customizable: You can easily optimise button location for according to the device your visitors will use.
- Choose from more than 20+ social networks to share with full control for every device that your visitors use.
- The sharing options can be positioned for the maximum effect according to whether the visitor is using a mobile device or desktop. Best of all they can be switched on/off from your WordPress instance.  
  
**Why use our header and footer scripts module:**
- It allows you to add global scripts in header or footer.
- You can add a script individually to run on a single page or post.

**Why use our custom Elementor addons module:**
- We offer new widgets to add more value to the content you can create within Elementor page builder.
- Pricing Table Widget to easily create pricing layouts.
- Services Widget to easily create pricing layouts.
- Post Grid Widget to easily list your Posts / Products / any other post types in a grid.

**Why use our custom Beaver Builder addons module:**
- We offer new widgets to add more value to the content you can create within the Beaver Builder page builder.
- Pricing Table Widget to easily create pricing layouts.
- Services Widget to easily create pricing layouts.
- Post Grid Widget to easily list your Posts / Products / any other post types in a grid.

**Why use our Template Directory:**
- One-click import for awesome page templates.
- Elementor templates will be added frequently for you to use creatively.

**Why use our Gutenberg Blocks:**
- We offer new widgets to add more value to the content you can create within the Gutenberg editor.
- Pricing Table Widget to easily create pricing layouts.
- Services Widget to easily create pricing layouts.
- Post Grid Widget to easily list your Posts in a grid.

**Why use our custom fonts module:**
- The free fonts from Google may not be enough to achieve the perfect design.
- It allows you to upload any font you'd like and use it on your site.
- It's fully integrated with Neve theme, all the fonst you'll add will be availabel in customizer.

## Installation ##

Activating the Orbit Fox plugin is just like any other plugin. If you've uploaded the plugin package to your server already, skip to step 5 below:

1. In your WordPress admin, go to **Plugins &gt; Add New**
2. In the Search field type "Orbit Fox"
3. Under "Orbit Fox" click the **Install Now** link
4. Once the process is complete, click the **Activate Plugin** link
5. Now, you're able to use Orbit fox and setup the modules you need. These can be found on the **Orbit Fox** dashboard page
6. Make the changes desired, then click the **Save changes** button at the bottom

## Screenshots ##

1. The OrbitFox Dashboard Page
2. The Template Directory Page
3. Menu Icons Module
4. Page Builder Widgets and Addons
5. Social Sharing Module

## Changelog ##

##### [Version 2.10.11](https://github.com/Codeinwp/themeisle-companion/compare/v2.10.10...v2.10.11) (2022-02-17)

- Replace the templates module with the one based on Neve and Cloud Templates & Patterns collection
- Fix warnings with PHP 8
- Update recommended plugins




##### [Version 2.10.10](https://github.com/Codeinwp/themeisle-companion/compare/v2.10.9...v2.10.10) (2021-12-23)

- Fix error with gutenberg-blocks




##### [Version 2.10.9](https://github.com/Codeinwp/themeisle-companion/compare/v2.10.8...v2.10.9) (2021-12-23)

- Improve cookie policy loading
- Improve upsells when the plugin is used with Neve theme to better inform the possibilities from pro




##### [Version 2.10.8](https://github.com/Codeinwp/themeisle-companion/compare/v2.10.7...v2.10.8) (2021-09-29)

- [Feat] Refactor the dashboard.
- [Feat] Add Telegram social sharing icon.
- [Fix] HomePage reverts to FrontPage if you have Orbit Fox Hestia Enhancements active and switch theme




##### [Version 2.10.7](https://github.com/Codeinwp/themeisle-companion/compare/v2.10.6...v2.10.7) (2021-08-02)

[Fix] Widgets with repeater fields are generating errors
[Fix] Gutenberg Blocks compatibility with WP 5.8
[Fix] Fix Elementor deprecated functions
- Retire the Uptime Monitor module.
- Announce the retirement of the Gutenberg Blocks module and remove it if the module is not used.
- Retire the Analytics module if the user is not using it.




##### [Version 2.10.6](https://github.com/Codeinwp/themeisle-companion/compare/v2.10.5...v2.10.6) (2021-05-31)

- [Fix] Replace Elementor deprecated functions




##### [Version 2.10.5](https://github.com/Codeinwp/themeisle-companion/compare/v2.10.4...v2.10.5) (2021-05-31)

- [Fix] PHP 8 errors
- [Fix] Elementor deprecated functions




##### [Version 2.10.4](https://github.com/Codeinwp/themeisle-companion/compare/v2.10.3...v2.10.4) (2021-03-09)

- [Fix] Translations and text-domain issues
- [Fix] Translation and text-domain issues.




##### [Version 2.10.3](https://github.com/Codeinwp/themeisle-companion/compare/v2.10.2...v2.10.3) (2020-12-17)

[Fix] removes role selector from registration content form
[Fix] ThemeIsle icons not appearing on WebKit browsers in Gutenberg blocks




##### [Version 2.10.2](https://github.com/Codeinwp/themeisle-companion/compare/v2.10.1...v2.10.2) (2020-12-09)

- [Fix] Fatal error on older versions of PHP




##### [Version 2.10.1](https://github.com/Codeinwp/themeisle-companion/compare/v2.10.0...v2.10.1) (2020-12-07)

- [Feat] New ascending/descending order option for Post Type Grid Elementor widget
- [Fix] Compatibility with WP 5.6
- [Fix] Header and Footer scripts not working on the Shop page
- [Fix] Remove Google Plus from the social-sharing module




#### [Version 2.10.0](https://github.com/Codeinwp/themeisle-companion/compare/v2.9.19...v2.10.0) (2020-10-09)

- New Custom Fonts module




##### [Version 2.9.19](https://github.com/Codeinwp/themeisle-companion/compare/v2.9.18...v2.9.19) (2020-09-25)

* Fix elementor post grid jQuery dependencies




##### [Version 2.9.18](https://github.com/Codeinwp/themeisle-companion/compare/v2.9.17...v2.9.18) (2020-09-21)

- [Fix] Missing FontAwesome icons when Otter Blocks plugin was active




##### [Version 2.9.17](https://github.com/Codeinwp/themeisle-companion/compare/v2.9.16...v2.9.17) (2020-09-02)

- [Fix] Compatibility with WP 5.5
- [Fix] Installing recommended plugins not working




##### [Version 2.9.16](https://github.com/Codeinwp/themeisle-companion/compare/v2.9.15...v2.9.16) (2020-08-12)

fix: add permission_callback for analytics module




##### [Version 2.9.15](https://github.com/Codeinwp/themeisle-companion/compare/v2.9.14...v2.9.15) (2020-08-12)

fix: notice showing up in the editor on the new WordPress version for users with WP_DEBUG turned on




##### [Version 2.9.14](https://github.com/Codeinwp/themeisle-companion/compare/v2.9.13...v2.9.14) (2020-08-07)

- Remove affiliate link




##### [Version 2.9.13](https://github.com/Codeinwp/themeisle-companion/compare/v2.9.12...v2.9.13) (2020-08-04)

- Removed Starter Sites library and import process used for the Neve theme
- [Fix] Menu Icons module not working with WP 5.5
- [Fix] Empty team member widget appearing on mobile in Hestia theme




##### [Version 2.9.12](https://github.com/Codeinwp/themeisle-companion/compare/v2.9.11...v2.9.12) (2020-07-20)

- New checkbox field in the Contact widget for both Elementor and Beaver Builder
- [Fix] Newsletter widget not taking into account the double opt-in option from Mailchimp




##### [Version 2.9.11](https://github.com/Codeinwp/themeisle-companion/compare/v2.9.10...v2.9.11) (2020-07-10)

- Starter Sites library and import process from the Neve theme




##### [Version 2.9.10](https://github.com/Codeinwp/themeisle-companion/compare/v2.9.9...v2.9.10) (2020-06-24)

- [Fix] JS error for some modules when the module names are translated




##### [Version 2.9.9](https://github.com/Codeinwp/themeisle-companion/compare/v2.9.8...v2.9.9) (2020-06-05)

New Header/Footer Scripts module




##### [Version 2.9.8](https://github.com/Codeinwp/themeisle-companion/compare/v2.9.7...v2.9.8) (2020-04-28)

- Fixed importing multiple photos and better error handling in the Mystock module




##### [Version 2.9.7](https://github.com/Codeinwp/themeisle-companion/compare/v2.9.6...v2.9.7) (2020-04-22)

- New Hidden field in the contact form widget
- Fix Mystock Import in the Gutenberg editor
- Fix overlapping widgets names with Beaver Builder Pro version
- Fix undefined index notice in Elementor Services widget
- Upgrade FontAwesome icons to FA5 for Hestia default content
- Make inline social icons round in Hestia
- Fix inline social icons not applying on pages in Hestia




##### [Version 2.9.6](https://github.com/Codeinwp/themeisle-companion/compare/v2.9.5...v2.9.6) (2020-04-06)

* Update compatibility with WordPress 5.4
* Sync dependencies
* Fix selective refresh for Hestia enhacements features




##### [Version 2.9.5](https://github.com/Codeinwp/themeisle-companion/compare/v2.9.4...v2.9.5) (2020-03-30)

* Fix notice on analytics module when the codes are missing
* Update dependencies to the latest versions




##### [Version 2.9.4](https://github.com/Codeinwp/themeisle-companion/compare/v2.9.3...v2.9.4) (2020-03-23)

* Improve FA loading in Hestia compatibility features
* Update dependencies




##### [Version 2.9.3](https://github.com/Codeinwp/themeisle-companion/compare/v2.9.2...v2.9.3) (2020-03-05)

* Update dependencies
* Fix admin notice viewed by non-admins




##### [Version 2.9.2](https://github.com/Codeinwp/themeisle-companion/compare/v2.9.1...v2.9.2) (2020-02-13)

* Fix issue with cookie notices closing behavior.
* Fix notice when Otter and Orbit Fox were both active.




##### [Version 2.9.1](https://github.com/Codeinwp/themeisle-companion/compare/v2.9.0...v2.9.1) (2020-02-05)

* Fix possible error with edge case legacy module loading.




#### [Version 2.9.0](https://github.com/Codeinwp/themeisle-companion/compare/v2.8.14...v2.9.0) (2020-02-03)

* Update dependencies
* Remove legacy modules



### 2.8.14 - 2019-12-02  ###

* Fix fatal error with Membership Pro
* Various bug fixes to forms and Elementor widgets


### 2.8.13 - 2019-11-18  ###

* Fix dependency issues on content forms module


### 2.8.12 - 2019-11-18  ###

* sync dependencies


### 2.8.11 - 2019-11-18  ###

* Various improvements for Beaver and Elementor form widgets.
* Improvements to the post grid Elementor module.
* Compatibility with WordPress 5.3


### 2.8.10 - 2019-09-13  ###

* Development


### 2.8.8 - 2019-09-11  ###

* Fixes Constant Warning for Beaver Widgets Module


### 2.8.7 - 2019-08-13  ###

* Fix error notice in menu icons


### 2.8.6 - 2019-08-12  ###

* Improve script loading performance
* Fix issue with mystock import


### 2.8.5 - 2019-07-26  ###

* Update Elementor content forms widgets compatiblity with the latest version.
* Various fixes for the gutenberg blocks module.


### 2.8.4 - 2019-05-23  ###

* minor adjustments to the dashboard UI
* various updates to the Gutenberg blocks available
* adds compatibility with WordPress 5.2


### 2.8.3 - 2019-04-20  ###

* Fixed issue with constant not being checked in Otter
* Added error handling in Backbone functions


### 2.8.2 - 2019-04-18  ###

* Fix PHP notice


### 2.8.1 - 2019-04-18  ###

* Fix issues with newsletter form


### 2.8.0 - 2019-04-02  ###

* Fix font awesome menu icons issue in the menu builder
* Fix issue on dismiss nag info for OrbitFox post install
* Fix menu icon possible conflicts report info
* FIx undefined error on new installs for image module
* Fix issues with mystock import on certain use cases
* Remove image CDN module for new users, service will be migrated to optimole plugin
* Adds recommended plugins tab into Orbitfox settings page.


### 2.7.5 - 2019-02-02  ###

* Improve compatibility with Image CDN module by disabling the feature if Optimole exits already


### 2.7.4 - 2019-02-01  ###

* update Gutenberg blocks library to the latest version
* fix dashicons issue with Neve theme
* load fontawesome locally if is not already loaded


### 2.7.3 - 2018-12-12  ###

* Revert Font Awesome 5 integration


### 2.7.2 - 2018-12-10  ###

* Tested with WP 5.0


### 2.7.1 - 2018-12-07  ###

* - Fix for Gutenberg blocks module loading


### 2.7.0 - 2018-11-26  ###

* Fix small typo on the module activation button.
* Improves compatibility with Hestia Theme.
* Adds compatibility for Neve theme.
* Fix translation text for Agree button in Cookie notice.


### 2.6.4 - 2018-11-12  ###

* Fix issue with elementor content forms php notice
* Add alignment options to content forms
* Security enhancements
* Performance enhancements


### 2.6.3 - 2018-10-29  ###

* - Minor bug fix in Gutenberg Blocks


### 2.6.2 - 2018-10-29  ###

* Adds Image Optimization and CDN module available for everyone.
* Small improvements to the Gutenberg module.


### 2.6.1 - 2018-10-10  ###

* Added backward compatibility for Font Awesome 4
* Fixed issue with Elementor dequeuing Font Awesome
* Fixed issue with Gutenberg Module crashing Orbit Fox dashboard
* Fixed issue with Pie Chart causing REST API error
* Fixed z-index issue in Accordion block.


### 2.6.0 - 2018-10-08  ###

* Adds Gutenberg integration with various blocks.
* Adds Font Awesome, Google maps, Notice, Sharing icons, Pie charts, Plugin Card, Pricing, Testimonial and Click to Tweet  Gutenberg block and Post grid block.


### 2.5.8 - 2018-09-12  ###

* Extend image optimization module for 50% of users.
* Enable safe updates for all users.
* Adds image optimization integration with Optimole.


### 2.5.7 - 2018-08-13  ###

* -fixed fatal error with Elementor extra widgets


### 2.5.6 - 2018-07-26  ###

* Release


### 2.5.5 - 2018-07-23  ###

* Add new controls for Elementor content forms.


### 2.5.4 - 2018-07-11  ###

* Fixed undefined method for old elementor versions.


### 2.5.3 - 2018-07-11  ###

* Small alignment fix for menu icons module
* Added styling options for Elementor content forms


### 2.5.2 - 2018-07-06  ###

* Fixes post grid pagination issue
* Fixes post grid colors not applying correctly
* Fixes Templates directory import issue
* New templates in the templates directory
* Fixes content forms placeholder not used
* Fixes for Hestia Theme enhancements module
* Fixes issue where url's were replaced with CDN url for beta users


### 2.5.1 - 2018-07-02  ###

* Fix social icons saving bug.
* Fix z-index issue on policy notice.


### 2.5.0 - 2018-06-22  ###

* Adds privacy policy module, allows users to set a notice for their visitors.
* Adds Image CDN and Optimization module in private BETA .
* Adds Themes Safe Updates module in private BETA.
* Adds more Elementor templates into the library.
* Improvements for Hestia enhancements module.


### 2.4.7 - 2018-05-03  ###

* Add content forms for Beaver Builder
* Bug fixes and performance enhancements for Hestia
* Fix issue with plugin activation and deactivation


### 2.4.6 - 2018-04-12  ###

* Add video to readme file
* Added notification about conflict with navwalker overrides
* Added safeguard for navwalker overrides
* Remove unused animation functions from Legacy Module
* Added Azera Shop, Llorix One Lite, Shop Isle themes functionality to Legacy Module


### 2.4.5 - 2018-03-29  ###

* Fixed issue with duplicated widgets in Hestia theme
* Fix undefined errors in Analytics Module
* Unset monitor email field on deactivation


### 2.4.4 - 2018-03-08  ###

* Fixed Analytics module error.
* UX Improvements.


### 2.4.3 - 2018-03-04  ###

* Fixed Analytics module issues.
* Better UX on module activation.


### 2.4.2 - 2018-03-02  ###

* Added a new Google Analytics Integration module
* Small UX improvements


### 2.4.1 - 2018-02-20  ###

* Added intent confirmation for uptime monitor.
* Register site to endpoint only if we have a valid email address.
* UX improvements for module activation.


### 2.4.0 - 2018-02-16  ###

* Adds a new module for uptime monitor of your website.
* Adds 4 more hooks for modules related actions.


### 2.3.1 - 2018-01-17  ###

* Disabled automatic display for sharing button on pages and added an option to toggle it.


### 2.3.0 - 2018-01-15  ###

* Adds 3 forms widgets for Elementor (Contact form, Newsletter, and Registration form).
* Improve menu icons copyright.
* Allows social icons on pages.
* Adds beaver widgets module active by default.


### 2.2.7 - 2017-12-21  ###

* Fix for Hestia clients section default content
* Beaver Builder Widgets show only if you have beaver builder installed
* Added Screenshots desciptions


### 2.2.6 - 2017-12-19  ###

* Added new Beaver Builder Widgets Module - Pricing table widget, Services widget, Posts Grid widget.
* Better user experience for the template directory.
* More native design for the template directory.
* Added three free new templates to the template directory - Path, Mocha and Ascend.
* Fixed bug with the Elementor Pricing Table widget button link.
* Fixed php notice given by the Elementor Posts Grid widget.
* Removed the useless Stats module.


### 2.2.5 - 2017-12-11  ###

* Better UX for CC0 images import module.
* Improved Elementor Services Widget.
* Added new templates to the template directory.


### 2.2.4 - 2017-12-04  ###

* Fixed issue with menu icons module loading.


### 2.2.3 - 2017-11-27  ###

* [Hestia] Fixed issue with Team member section not opening external links in a new tab
* [Hestia] Fixed alignment issues with the front page sections


### 2.2.2 - 2017-11-24  ###

* Renamed flickr api util file.
* Fixed issue with template directory preview plugin install modal.


### 2.2.1 - 2017-11-24  ###

* Fixed module loading for Elementor widgets module.


### 2.2.0 - 2017-11-23  ###

* - Added new Elementor Widgets module;
* - Added new Template Directory module;
* - Bug fixes for the Photos Import Module;
* - Bug fixes for the Social Sharing module backend interface;
* - Moved Orbit Fox Companion out of Tools Menu;


### 2.1.1 - 2017-11-16  ###

* Adds compatibility with WordPress 4.9.


### 2.1.0 - 2017-11-08  ###

* Adds custom icons menu module.
* Adds free stock images integration with mystock.photos .


### 2.0.11 - 2017-10-19  ###

* Fixed alignment issue for titles in Hestia


### 2.0.10 - 2017-10-18  ###

* Added selective refresh options for the Show/Hide frontpage controls in Hestia
* Make external links open in new tab for the frontpage sections in Hestia
* Added some new filters to control the number of items per row appear in the Features and Testimonials Frontpage section - http://docs.themeisle.com/article/669-how-to-add-4-feature-items-on-a-line-in-hestia


### 2.0.9 - 2017-10-17  ###

* Enhanced layout for Hestia sections.


### 2.0.8 - 2017-10-11  ###

* Fixed bug with URL protocols filter priority.
* Fixed bug with icons background styled by URL address.


### 2.0.7 - 2017-10-02  ###

* New improved options for frontpage sections ordering/disabling in Hestia


### 2.0.6 - 2017-09-19  ###

* Added selective refresh for titles options in the frontpage sections in Hestia


### 2.0.5 - 2017-09-12  ###

* Added new Ribbon and Clients Bar sections in Hestia


### 2.0.4 - 2017-09-11  ###

* Adds PHP minimum requirement.
* Fix for admin styles loading screen.


### 2.0.3 - 2017-08-24  ###

* Improved compatibility with the new Hestia version.


### 2.0.2 - 2017-08-16  ###

* Fix accordion not opening to display save buttons for modules


### 2.0.1 - 2017-08-14  ###

* Fixed issues with grey icons in Hestia.
* Fixed Recommended Actions flags in customizer.



### 1.0.3 ###

* New widgets for Rhea child theme
* Improved front page selection mechanism for Hestia

### 1.0.1 ###

* Changed tested up to

### 1.0.0 ###

* First version of the plugin
